
====

**Quiz-1**

**Which of the following deployment modes is NOT supported by Cisco Secure Firewall Threat Defense?**

A) Routed Mode  
B) Transparent Mode  
C) Inline Tap Mode  
D) Stateful Mode

**Correct Answer: D) Stateful Mode**

**Reason:**  
Cisco Secure Firewall Threat Defense supports routed mode, transparent mode, and inline tap mode as deployment options. "Stateful Mode" is not a deployment mode; rather, it refers to the firewall's ability to maintain state information of active connections, which is a characteristic of its operation, not a mode of deployment.

=====

**Quiz -2** 

Which statement describes Secure Firewall Threat Defense IDS inline tap mode?

- To deploy Secure Firewall Threat Defense where it will block only high-critical events.
    
- To ensure that if one interface goes down in an inline set, the other interface is also taken down.
    
- To have an inline set act as a tap—a copy of the traffic is analyzed.
    
- IDS inline tap mode is supported only in Secure Firewall Threat Defense transparent mode.

### Answer

The correct answer is: **To have an inline set act as a tap—a copy of the traffic is analyzed**.

=====

**Quiz -3** 

Which engine within the Cisco Secure Firewall Threat Defense device is primarily responsible for handling traffic inspection functions, including security intelligence and Cisco URL Filtering?

A. The LINA engine

B. The ASA engine

C. The Snort engine

D. The VPN engine

**Correct Answer: C. The Snort engine**

**Reason:**

The Snort engine in Cisco Secure Firewall Threat Defense is specifically designed to perform deep traffic inspections, including security intelligence, intrusion prevention systems (IPS), and Cisco URL Filtering. This engine goes beyond basic Layer 3/Layer 4 processing to inspect and modify traffic based on more detailed security criteria. The LINA engine handles more standard traffic processing and filtering tasks, such as IP routing and NAT.


=====

**Quiz -4** 

In the Cisco Secure Firewall Threat Defense packet processing sequence, what is the primary purpose of the Prefilter policy?

A. To encrypt outgoing traffic

B. To fastpath traffic, excluding it from Snort engine inspection

C. To perform IP routing and NAT processing

D. To decrypt incoming VPN traffic

**Correct Answer: B. To fastpath traffic, excluding it from Snort engine inspection**

**Reason:**

The Prefilter policy in Cisco Secure Firewall Threat Defense is designed to quickly process certain traffic and exclude it from deeper inspection by the Snort engine. This helps optimize system performance by reducing the load on the Snort engine for traffic that doesn't require detailed analysis.

=====

**Quiz -5** 

  
Which policy in Cisco Secure Firewall Threat Defense is responsible for inspecting traffic up to Layer 7 and integrating URL lists for web security?

A. SSL Policy

B. Access Control Policy (ACP)

C. File Policy

D. Network Discovery Policy

**Correct Answer: B. Access Control Policy (ACP)**

**Reason:**

The Access Control Policy (ACP) in Cisco Secure Firewall Threat Defense is the central component responsible for inspecting traffic up to Layer 7. It allows for the configuration of access rules, URL lists, and integrates other security measures such as IPS and file policies to ensure comprehensive web security and compliance.

=====

**Quiz -6** 

Which of the following statements correctly describes how objects are used in Cisco Management Center for configuring policies?

A. Objects are only used for defining network security zones.

B. Objects can be defined directly within policies like Access Control Policies (ACP) and reused across different configurations.

C. Objects are static configurations and cannot be edited once created.

D. Objects must be deleted before modifying any policy they are associated with.

**Correct Answer: B. Objects can be defined directly within policies like Access Control Policies (ACP) and reused across different configurations.**

**Reason:**

Objects in Cisco Management Center are designed to be reusable configurations that can be defined within policies such as Access Control Policies (ACP). They associate a name with a value, and once created, they can be referenced across various configurations, making it easier to manage and analyze the setup. Additionally, editing an object used in a policy requires reapplying that policy, rather than deleting the object.

=====

**Quiz -7**

Which type of NAT is most suitable for a scenario where multiple internal servers need to be reachable from outside the network using a single public IP address with different service ports?

A. Static NAT

B. Dynamic NAT

C. Static PAT

D. Dynamic PAT

**Correct Answer: C. Static PAT**

**Reason:** Static PAT, also known as port forwarding, allows you to map multiple internal servers to a single public IP address while distinguishing them by different service ports. This is particularly useful when you have limited public IP addresses but need external access to multiple services hosted internally. Static NAT would not differentiate by port, and Dynamic PAT uses many-to-one mappings which aren't suitable for specifying different service ports for distinct servers.

=====

**Quiz -8**

Which NAT configuration type allows for specifying both real and mapped IP addresses for source and destination within a single rule, enabling policy NAT and exceptions?

A. Auto NAT

B. Static NAT

C. Dynamic NAT

D. Manual NAT

**Correct Answer: D. Manual NAT**

**Reason:** Manual NAT allows for detailed configuration by specifying both real and mapped source and destination IP addresses within a single rule. This capability is essential for implementing policy NAT and handling exceptions, as it provides flexibility in determining how specific traffic should be translated. Auto NAT does not offer this level of granularity, focusing instead on simpler configurations.

=====

**Quiz - 9**

Which three actions are valid actions inside a pre-filter rule? 

- Permit
    
- Deny
    
- Block
    
- Fastpath
    
- Allow
    
- Drop
    
- Analyze
    
- Slowpath

**Answers**: 
The correct answers are: **Block**, **Fastpath**, and **Analyze**. Actions inside a prefilter rule are: Block, Analyze, and Fastpath.

=====

**Quiz - 10**

When configuring an Access Control Policy (ACP) rule in Cisco Secure Firewall Threat Defense, what must be true for traffic to match the rule?

A. The traffic must match at least one condition within the rule.

B. The traffic must match all conditions specified in the rule.

C. The traffic must be encrypted using SSL/TLS.

D. The traffic must originate from a trusted network.

**Correct Answer: B. The traffic must match all conditions specified in the rule.**

**Reason:** For traffic to match an ACP rule, it must meet all the conditions specified within the rule. This ensures precise control over which traffic is affected by the rule, allowing for detailed and comprehensive policy implementation.

=====

**Quiz - 11**

Which action is taken by Security Intelligence when traffic matches a Do Not Block list in Cisco Secure Firewall Threat Defense?

A. The traffic is blocked immediately without further inspection.

B. The traffic is monitored but not blocked.

C. The traffic is allowed to proceed without generating events.

D. The traffic is sent for further inspection and analysis.

**Correct Answer: C. The traffic is allowed to proceed without generating events.**

**Reason:** When traffic matches a Do Not Block list, it is treated as non-malicious and allowed to proceed through the Threat Defense processing pipeline without generating events. This list is used to override entries that may mistakenly appear in the Block list, ensuring that legitimate traffic is not interrupted.


=====

**Quiz - 12**

During the configuration of network discovery in Cisco Secure Firewall Threat Defense, a new administrator wants to ensure that only internal network traffic contributes to host profiles. Which strategy should they employ to achieve this goal?

A. Enable active detection using Nmap for all external IP addresses

B. Configure the discovery policy to exclude social networking applications

C. Define discovery rules that include only private IP address ranges

D. Deploy a global Do Not Block list for external IP addresses

**Correct Answer: C. Define discovery rules that include only private IP address ranges**

**Reason:** To ensure that host profiles are generated only from internal network traffic, the administrator should configure discovery rules that target private IP address ranges, excluding external traffic. This approach prevents host profiles from being built based on internet traffic, focusing discovery efforts on the desired network segments.

=====

**Quiz - 13**

In Cisco Firepower Management Center (FMC), where do you navigate to configure NAT rules for a Threat Defense device?

A) Dashboard > Device Management > NAT Configuration

B) Policies > Access Control > NAT Settings

C) Devices > Device Management > NAT Policy

D) Devices > NAT


![[Pasted image 20250331084801.png]]

Correct Answer:

D) Devices > NAT

  

**Explanation:**

To configure NAT rules in Cisco FMC, you navigate to the 

**Devices** section and select **NAT**. 

This path allows you to manage NAT configurations for your Threat Defense devices, enabling you to set up both Auto NAT and Manual NAT rules according to your network requirements. This section is specifically designed for handling NAT policies and settings.


=======

**Quiz - 14**

In Cisco Firepower Threat Defense (FTD), how do the LINA engine and Snort engine collaborate to manage network traffic and security?
![[Pasted image 20250331085714.png]]
  

A) LINA provides foundational network services, while Snort enhances security through detailed inspection of traffic.
B) LINA independently handles security and network functions, leaving Snort unused in FTD deployments.
C) LINA and Snort operate in parallel to process all traffic flows simultaneously.
D) LINA focuses on deep packet inspection, while Snort manages basic network routing and NAT

**Correct Answer:**

A) LINA provides foundational network services, while Snort enhances security through detailed inspection of traffic.

_Explanation:_

_In Cisco FTD, LINA is responsible for core network services such as routing, NAT, and basic packet processing. Snort complements these functions by providing advanced security capabilities through deep packet inspection, ensuring threats are detected and mitigated effectively. This collaboration allows FTD to deliver both robust network performance and comprehensive security._


=======

**Quiz - 15**


Which of the following statements best describes the processing order for NAT rules in Cisco Firepower Threat Defense (FTD)?

A) NAT rules are processed based on the rule type, starting with Dynamic NAT, followed by Static NAT, and then Auto NAT.

B) NAT rules are processed in a single section, where Auto NAT rules are evaluated first, followed by Manual NAT rules.

C) NAT rules are organized into three sections, with Manual NAT rules in Section 1 processed first, followed by Auto NAT rules in Section 2, and concluding with Manual NAT rules in Section 3.

D) NAT rules are processed based on the number of IP addresses, starting with rules involving larger address pools.

**Correct Answer:**

C) NAT rules are organized into three sections, with Manual NAT rules in Section 1 processed first, followed by Auto NAT rules in Section 2, and concluding with Manual NAT rules in Section 3.

**Explanation**:

In Cisco FTD, NAT rules are divided into three sections within the NAT table:

_Section 1: Contains Manual NAT rules, applied first on a first-match basis, allowing for specific configurations like Twice NAT and NAT exemptions._

_Section 2: Contains Auto NAT rules, evaluated after Section 1. These include Static and Dynamic NAT configurations, processed in a specific order based on the quantity and type of IP addresses._

_Section 3: Contains additional Manual NAT rules, serving as a catch-all for any traffic not matched by previous sections, ensuring broader and more general translations._

_The entire NAT table is read top-down, ensuring that once a match is found, subsequent sections are not evaluated. This structured approach allows for precise control over NAT translations and policy implementations._

=======

**Quiz - 16**

What happens when you attempt to delete a group within Cisco Firepower Threat Defense (FTD), and under what condition is deletion not permitted?

A) Deleting a group removes all objects within it, and you cannot delete a group unless it is part of an inactive policy.
B) Deleting a group only removes the association between objects, and you cannot delete a group if it is used in an active policy.
C) Deleting a group automatically deactivates any associated policies, allowing deletion of all groups.
D) Deleting a group affects all active policies, causing them to reset to default settings.

**Correct Answer:**
B) Deleting a group only removes the association between objects, and you cannot delete a group if it is used in an active policy.

=======

**Quiz - 16**

In the context of Cisco Secure Firewall Threat Defense, which feature allows you to block specific file types or malware during network traffic inspection, and relies on AMP technology for enhanced malware detection?

A) Intrusion Prevention System (IPS) policies

B) File Type Detection and Malware Protection

C) Access Control Policy (ACP)

D) Network Routing Protocols

**Correct Answer:**

B) File Type Detection and Malware Protection

**Reason:**

File Type Detection and Malware Protection are features of Cisco Secure Firewall Threat Defense that allow administrators to detect or block specific file types and malware during network traffic inspection. The malware protection aspect relies on Advanced Malware Protection (AMP) technology for enhanced detection capabilities, distinguishing it from IPS policies, ACP, or network routing protocols, which serve different purposes within the network security framework.

=======

**Lab Quiz - 1** 

Navigate the FMC console to find the Security Zones Configured.

Answer - Security Zones can be examined inside the Object Manager by navigating to Objects > Object Management > Interface.

=======

**Lab Quiz - 2** 

Change the default ACP action to Block Traffic

**Answer** - Inside the management center, navigate to Policies > Access Control > Access Control. Click the default action on the bottom. 

=======

**Lab Quiz - 3** 

Configure the system to submit URLs to the cloud for threat intelligence evaluation when users browse to a website whose category and reputation are not in the local dataset.

**Answer** - From Integration > Other Integrations > Cloud Services > URL filtering

=======

**Lab Quiz - 4**


Check the Vulnerabilities on the Network

**Answer** - Navigate to Analysis > Vulnerabilities > Vulnerabilities on the Network

=======

**Lab Quiz - 5**

Consider FMC as a Cisco switch. How would you copy running-config startup-config 

**Answer** - Deploy the changes made so far on the FMC console

===================